/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.corpse.gui;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.corpse.Main;
import de.maxhenkel.corpse.corelib.CachedMap;
import de.maxhenkel.corpse.corelib.death.Death;
import de.maxhenkel.corpse.corelib.inventory.ScreenBase;
import de.maxhenkel.corpse.entities.DummyPlayer;
import de.maxhenkel.corpse.gui.DeathHistoryContainer;
import de.maxhenkel.corpse.net.MessageShowCorpseInventory;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class DeathHistoryScreen
extends ScreenBase<Container> {
    private static final ResourceLocation DEATH_HISTORY_GUI_TEXTURE = new ResourceLocation("corpse", "textures/gui/gui_death_history.png");
    private final CachedMap<Death, DummyPlayer> players = new CachedMap(10000L);
    private Button previous;
    private Button next;
    private List<Death> deaths;
    private int index;
    private int hSplit;
    private static boolean errorShown;

    public DeathHistoryScreen(List<Death> deaths) {
        super(DEATH_HISTORY_GUI_TEXTURE, new DeathHistoryContainer(), null, (ITextComponent)new TranslationTextComponent("gui.death_history.corpse.title"));
        this.deaths = deaths;
        this.index = 0;
        this.field_146999_f = 248;
        this.field_147000_g = 166;
        this.hSplit = this.field_146999_f / 2;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_230710_m_.clear();
        int padding = 7;
        int buttonWidth = 50;
        int buttonHeight = 20;
        this.previous = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + padding, this.field_147009_r + this.field_147000_g - buttonHeight - padding, buttonWidth, buttonHeight, (ITextComponent)new TranslationTextComponent("button.corpse.previous"), button -> {
            --this.index;
            if (this.index < 0) {
                this.index = 0;
            }
        }));
        this.func_230480_a_((Widget)new Button(this.field_147003_i + (this.field_146999_f - buttonWidth) / 2, this.field_147009_r + this.field_147000_g - buttonHeight - padding, buttonWidth, buttonHeight, (ITextComponent)new TranslationTextComponent("button.corpse.show_items"), button -> Main.SIMPLE_CHANNEL.sendToServer((Object)new MessageShowCorpseInventory(this.getCurrentDeath().getPlayerUUID(), this.getCurrentDeath().getId()))));
        this.next = (Button)this.func_230480_a_((Widget)new Button(this.field_147003_i + this.field_146999_f - buttonWidth - padding, this.field_147009_r + this.field_147000_g - buttonHeight - padding, buttonWidth, buttonHeight, (ITextComponent)new TranslationTextComponent("button.corpse.next"), button -> {
            ++this.index;
            if (this.index >= this.deaths.size()) {
                this.index = this.deaths.size() - 1;
            }
        }));
    }

    public boolean func_231044_a_(double x, double y, int clickType) {
        if (x >= (double)(this.field_147003_i + 7) && x <= (double)(this.field_147003_i + this.hSplit) && y >= (double)(this.field_147009_r + 70)) {
            this.field_230712_o_.getClass();
            if (y <= (double)(this.field_147009_r + 100 + 9)) {
                BlockPos pos = this.getCurrentDeath().getBlockPos();
                IFormattableTextComponent teleport = TextComponentUtils.func_240647_a_((ITextComponent)new TranslationTextComponent("chat.coordinates", new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()})).func_240700_a_(style -> style.func_240721_b_(TextFormatting.GREEN).func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/execute in " + this.getCurrentDeath().getDimension() + " run tp @s " + pos.func_177958_n() + " " + pos.func_177956_o() + " " + pos.func_177952_p())).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new TranslationTextComponent("chat.coordinates.tooltip"))));
                this.field_230706_i_.field_71439_g.func_145747_a((ITextComponent)new TranslationTextComponent("chat.corpse.teleport_death_location", new Object[]{teleport}), Util.field_240973_b_);
                this.field_230706_i_.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                this.field_230706_i_.func_147108_a(null);
            }
        }
        return super.func_231044_a_(x, y, clickType);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        Death death = this.getCurrentDeath();
        IFormattableTextComponent title = new TranslationTextComponent("gui.corpse.death_history.title").func_240699_a_(TextFormatting.BLACK);
        int titleWidth = this.field_230712_o_.func_78256_a(title.getString());
        this.field_230712_o_.func_238422_b_(matrixStack, title.func_241878_f(), (float)((this.field_146999_f - titleWidth) / 2), 7.0f, 0);
        IFormattableTextComponent date = new StringTextComponent(DeathHistoryScreen.getDate(death.getTimestamp()).getString()).func_240699_a_(TextFormatting.DARK_GRAY);
        int dateWidth = this.field_230712_o_.func_238414_a_((ITextProperties)date);
        this.field_230712_o_.func_238422_b_(matrixStack, date.func_241878_f(), (float)((this.field_146999_f - dateWidth) / 2), 20.0f, 0);
        this.drawLeft(matrixStack, new TranslationTextComponent("gui.corpse.death_history.name").func_230529_a_((ITextComponent)new StringTextComponent(":")).func_240699_a_(TextFormatting.DARK_GRAY), 40);
        this.drawRight(matrixStack, new StringTextComponent(death.getPlayerName()).func_240699_a_(TextFormatting.GRAY), 40);
        IFormattableTextComponent dimension = new TranslationTextComponent("gui.corpse.death_history.dimension").func_230529_a_((ITextComponent)new StringTextComponent(":")).func_240699_a_(TextFormatting.DARK_GRAY);
        this.drawLeft(matrixStack, dimension, 55);
        String dimensionName = death.getDimension().split(":")[1];
        boolean shortened = false;
        int dimWidth = this.field_230712_o_.func_238414_a_((ITextProperties)dimension);
        while (dimWidth + this.field_230712_o_.func_78256_a(dimensionName + (shortened ? "..." : "")) >= this.hSplit - 7) {
            dimensionName = dimensionName.substring(0, dimensionName.length() - 1);
            shortened = true;
        }
        this.drawRight(matrixStack, new StringTextComponent(dimensionName + (shortened ? "..." : "")).func_240699_a_(TextFormatting.GRAY), 55);
        this.drawLeft(matrixStack, new TranslationTextComponent("gui.corpse.death_history.location").func_230529_a_((ITextComponent)new StringTextComponent(":")).func_240699_a_(TextFormatting.DARK_GRAY), 70);
        this.drawRight(matrixStack, new StringTextComponent(Math.round(death.getPosX()) + " X").func_240699_a_(TextFormatting.GRAY), 70);
        this.drawRight(matrixStack, new StringTextComponent(Math.round(death.getPosY()) + " Y").func_240699_a_(TextFormatting.GRAY), 85);
        this.drawRight(matrixStack, new StringTextComponent(Math.round(death.getPosZ()) + " Z").func_240699_a_(TextFormatting.GRAY), 100);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        DummyPlayer dummyPlayer = this.players.get(death, () -> new DummyPlayer(this.field_230706_i_.field_71441_e, new GameProfile(death.getPlayerUUID(), death.getPlayerName()), death.getEquipment(), death.getModel()));
        InventoryScreen.func_228187_a_((int)((int)((double)this.field_146999_f * 0.75)), (int)(this.field_147000_g / 2 + 30), (int)40, (float)((int)((double)this.field_147003_i + (double)this.field_146999_f * 0.75) - mouseX), (float)(this.field_147000_g / 2 - mouseY), (LivingEntity)dummyPlayer);
        if (mouseX >= this.field_147003_i + 7 && mouseX <= this.field_147003_i + this.hSplit && mouseY >= this.field_147009_r + 70) {
            this.field_230712_o_.getClass();
            if (mouseY <= this.field_147009_r + 100 + 9) {
                this.func_238654_b_(matrixStack, Collections.singletonList(new TranslationTextComponent("tooltip.corpse.teleport").func_241878_f()), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
                return;
            }
        }
        if (mouseX < this.field_147003_i + 7) return;
        if (mouseX > this.field_147003_i + this.hSplit) return;
        if (mouseY < this.field_147009_r + 55) return;
        this.field_230712_o_.getClass();
        if (mouseY > this.field_147009_r + 55 + 9) return;
        this.func_238654_b_(matrixStack, Lists.newArrayList((Object[])new IReorderingProcessor[]{new TranslationTextComponent("gui.corpse.death_history.dimension").func_241878_f(), new StringTextComponent(death.getDimension()).func_240699_a_(TextFormatting.GRAY).func_241878_f()}), mouseX - this.field_147003_i, mouseY - this.field_147009_r);
    }

    public static ITextComponent getDate(long timestamp) {
        SimpleDateFormat dateFormat;
        try {
            dateFormat = new SimpleDateFormat(new TranslationTextComponent("gui.corpse.death_history.date_format").getString());
        }
        catch (Exception e) {
            if (!errorShown) {
                Main.LOGGER.error("Failed to create date format. This indicates a broken translation: 'gui.corpse.death_history.date_format' translated to {}", (Object)new TranslationTextComponent("gui.corpse.death_history.date_format").getString());
                errorShown = true;
            }
            dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        }
        return new StringTextComponent(dateFormat.format(new Date(timestamp)));
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        this.previous.field_230693_o_ = this.index > 0;
        this.next.field_230693_o_ = this.index < this.deaths.size() - 1;
    }

    public void drawLeft(MatrixStack matrixStack, IFormattableTextComponent text, int height) {
        this.field_230712_o_.func_238422_b_(matrixStack, text.func_241878_f(), 7.0f, (float)height, 0);
    }

    public void drawRight(MatrixStack matrixStack, IFormattableTextComponent text, int height) {
        int strWidth = this.field_230712_o_.func_238414_a_((ITextProperties)text);
        this.field_230712_o_.func_238422_b_(matrixStack, text.func_241878_f(), (float)(this.hSplit - strWidth), (float)height, 0);
    }

    public Death getCurrentDeath() {
        return this.deaths.get(this.index);
    }
}

